

![Parralels](https://www.parallels.com/static/pl/fileadmin/res/img/navigation/pl-logo-dk.png)

# AppserverClient Command Line Interface

## savefavorites

saves a comma separated list of the published items added to Favorites.

**Category: RAS-Connections**




```  
AppServerClientCLI savefavorites -id ras:5 -favorites 2,5,10 [-synch] [-window 12345]  
```
## Arguments  
* **` id (mandatory) `** Specify the RAS connection ID to use.  
* **` favorites (mandatory) `** Specify the published items to save in Favorites.  
* **` synch (optional) `** Return once data is processed by the backend. See notes for further information.  
* **` window (optional) `** Specify the window handle that will be used as the parent to any UI required.

## Return codes:  
  ok - Command was successful  
  NotAvailable - Communication with the client backend failed, ensure that the client is running  
  InvalidId - Invalid connection, object or session ID  
  InvalidArgs - Some arguments are missing or invalid  
  ElevationAccess - CLI process is running at a higher process privilege  
  Exception - System problem

## Examples:  
  AppServerClientCLI savefavorites 

## Notes:  
  With the synch on, this method will return once the data is processed by the backend, but before it is sent to the RAS server.  
  If the RAS server is not reached or failed, you will not be notified.

## See also:  
[logonras](logonras.md)    
[logoffras](logoffras.md)    
[logoffallras](logoffallras.md)    
[logoffrassession](logoffrassession.md)    
[startrasobj](startrasobj.md)    
[disconnectras](disconnectras.md)    
[disconnectallras](disconnectallras.md)    
[getloggedrasinfo](getloggedrasinfo.md)    
[getraspolicyinfo](getraspolicyinfo.md)    
[getpublicipinfo](getpublicipinfo.md)    
[clearpublicipinfo](clearpublicipinfo.md)  
