

![Parralels](https://www.parallels.com/static/pl/fileadmin/res/img/navigation/pl-logo-dk.png)

# AppserverClient Command Line Interface

## addconnection

creates a new connection with or without showing the UI.

**Category: Connections**




```  
AppServerClientCLI addconnection [-type ras/rdp] [-server 10.2.3.4]  [-username user] [-password pwd] [-alias alias] [-mode 0] [-port 443] [-window 12345]  
```
## Arguments  
* **` type (optional) `** Specify the type of connection to add, which can be either RAS or RDP.  
* **` server (optional) `** Specify the server to connect to.  
* **` username (optional) `** Specify the username.  
* **` password (optional) `** Specify the password.  
* **` alias (optional) `** Specify the display name of the connection.  
* **` mode (optional) `** Specify the connection mode.  
* **` port (optional) `** Specify the port to connect to. If not specified, port 443 will be used.  
* **` window (optional) `** Specify the window handle that will be used as the parent to any UI required.

## Return codes:  
  ok - Command was successful  
  NotAvailable - Communication with the client backend failed, ensure that the client is running  
  InvalidArgs - Some arguments are missing or invalid  
  AlreadyPresent - New connection cannot be added since the server and friendly name are already used  
  AccessDenied - Logged on user does not have permission to perform the action  
  ElevationAccess - CLI process is running at a higher process privilege  
  Exception - System problem

## Examples:  
  AppServerClientCLI addconnection   
  AppServerClientCLI addconnection  -type rdp  
  AppServerClientCLI addconnection  -type ras -server myserver -username user -password pwd  
  AppServerClientCLI addconnection  -type rdp -server myserver -username user -password pwd

## Notes:  
  If you do not pass any arguments, or specify the type only, the UI will be used to enter the remaining information.  
  If you need to add a connection without UI, you need to specify the server, username and password. Other arguments are optional.

## See also:  
[listconnections](listconnections.md)    
[updateconnection](updateconnection.md)    
[duplicateconnection](duplicateconnection.md)    
[deleteconnection](deleteconnection.md)    
[getshareddevice](getshareddevice.md)    
[setshareddevice](setshareddevice.md)    
[clearshareddevice](clearshareddevice.md)  
