
![Parralels](https://www.parallels.com/static/pl/fileadmin/res/img/navigation/pl-logo-dk.png)

# AppserverClient Command Line Interface 


```
AppServerClientCLI [command] [arguments]
```

If no command is passed, the application you will enter the command shell which allows multiple inputs using the same process.
In this mode you can use additional internal commands.

For additional help on each command, type "AppServerClientCLI help command".
##  Example:
  AppServerClientCLI help listconnections



# Command descriptions
[help](help.md): provides information on the existing commands.
[generatehelptxt](generatehelptxt.md): generates documentation about the CLI interface in the plain text format.
[generatehelphtml](generatehelphtml.md): generates documentation about the CLI interface in the HTML format.
[generatehelpmd](generatehelpmd.md): generates documentation about the CLI interface in the Markdown format.
[version](version.md): provides version information for the CLI interface.
[checkforupdate](checkforupdate.md): checks whether a new version of Parallels Client is available (also checks the AVD client).
[isssoenabled](isssoenabled.md): checks whether the SSO component is enabled.
[enablesso](enablesso.md): enables or disables the SSO component.
[listconnections](listconnections.md): provides information on existing connections.
[addconnection](addconnection.md): creates a new connection with or without showing the UI.
[updateconnection](updateconnection.md): changes credentials and (optionally) hardware ID.
[deleteconnection](deleteconnection.md): deletes an existing connection.
[logonras](logonras.md): logs on to a RAS connection.
[logoffras](logoffras.md): logs off from a RAS connection.
[disconnectras](disconnectras.md): disconnects an RDP session from a single RAS connection.
[disconnectallras](disconnectallras.md): disconnects all RDP sessions from all RAS connection.
[logoffallras](logoffallras.md): logs off from all RAS connections.
[logoffrassession](logoffrassession.md): logs off from a session created from a RAS connection.
[connectrdpobj](connectrdpobj.md): starts an RDP connection.
[disconnectrdpobj](disconnectrdpobj.md): stops an RDP connection.
[disconnectallrdp](disconnectallrdp.md): disconnects from all RDP connection.
[startrasobj](startrasobj.md): starts a published object from a RAS connection.
[showwnd](showwnd.md): brings up the UI window.
[savefavorites](savefavorites.md): saves a comma separated list of the published items added to Favorites.
[createshortcut](createshortcut.md): creates a shortcut for an RDP connection or a published desktop or application.
[createfavoritesshortcuts](createfavoritesshortcuts.md): creates shortcuts for all applications added to Favorites in a RAS connection.
[deleteallshortcuts](deleteallshortcuts.md): deletes all shortcuts on the desktop.
[startnotifications](startnotifications.md): registers the CLI application as a receiver of notifications from the backend.
[stopnotifications](stopnotifications.md): unregisters the CLI application as a receiver of notifications from the backend.
[setsmartsizing](setsmartsizing.md): changes smart-sizing runtime settings for an RDP connection session.
[getsmartsizing](getsmartsizing.md): retrieves smart-sizing runtime settings for an RDP connection session.
[sendkeys](sendkeys.md): sends keys to an active session.
[getsessionsinfo](getsessionsinfo.md): returns the sessions information.
[disconnectsession](disconnectsession.md): disconnects a session created from a RAS or RDP connection.
[getraspolicyinfo](getraspolicyinfo.md): returns information about the set policies.
[getsettings](getsettings.md): fetches settings of a connection or generic to Parallels Client.
[setsettings](setsettings.md): updates settings from a connection or generic to Parallels Client.
[settingsinfo](settingsinfo.md): gets information about settings.
[iscanaction](iscanaction.md): checks whether an action command is available.
[getloggedrasinfo](getloggedrasinfo.md): gets information about an already logged on RAS connection.
[startclient](startclient.md): starts Parallels Client.
[restartclient](restartclient.md): closes and restarts an active instance of Parallels Client.
[stopclient](stopclient.md): closes Parallels Client.
[listavailablebrowsers](listavailablebrowsers.md): gets a list of available browsers to use as external browsers for web authentication.
[listavailablessoproviders](listavailablessoproviders.md): gets a list of available third-party credential providers to use with SSO wrapping.
[listavailabledisplays](listavailabledisplays.md): gets a list of available displays.
[listavailablecameras](listavailablecameras.md): gets a list of available video capturing devices.
[listavailabledevices](listavailabledevices.md): gets a list of other supported devices.
[listavailablescanners](listavailablescanners.md): gets a list of available scanners.
[exportsettings](exportsettings.md): exports the settings of Parallels Client.
[importsettings](importsettings.md): imports previously exported settings to Parallels Client.
[factoryreset](factoryreset.md): deletes all connections and resets all settings to the default values or resets connection settings.
[clientviewlog](clientviewlog.md): shows Parallels Client log file.
[clientreadlog](clientreadlog.md): reads the contents of Parallels Client log file.
[clientclearlog](clientclearlog.md): clears Parallels Client log file.
[clientversion](clientversion.md): provides version information for Parallels Client.
[enablelog](enablelog.md): enables log. All commands called after this will be logged into the log file.
[disablelog](disablelog.md): disables log.
[clearlog](clearlog.md): clears the log file.
[viewlog](viewlog.md): shows the log file.
[uploadfile](uploadfile.md): upload a file to the remote session.
[downloadfile](downloadfile.md): download a file from the remote session.
[universalprintingmonitor](universalprintingmonitor.md): manages monitoring of universal printing jobs.



# Internal command descriptions
[quit](quit.md): closes the CLI.
[cls](cls.md): clears the CLI terminal window.
[useautoidon](useautoidon.md): enables the auto ID mode. When enabled, if the command return an ID, it can be automatically used in the next commands if an argument is not passed to them.
[useautoidoff](useautoidoff.md): disables the auto ID mode.
[useautostartclienton](useautostartclienton.md): enables the auto start client mode. When enabled, Parallels Client starts automatically if a command requires it.
[useautostartclientoff](useautostartclientoff.md): disables the auto start client mode.
[sleep](sleep.md): waits for a number of seconds.
[loop](loop.md): executes the following command a number of times.
[recordon](recordon.md): enables the record mode. When enabled, all entered commands are saved in the memory and can be played back or saved.
[recordoff](recordoff.md): disables the record mode.
[recordclear](recordclear.md): clears the recorded commands.
[recordplay](recordplay.md): replays the recorded commands. Optionally, you can load commands from a file before they are played.
[recordsave](recordsave.md): saves records to a file. If no filename is passed, you will be prompted for one.
[recordload](recordload.md): loads records from a file. If no filename is passed, you will be prompted for one.
[recorddebugon](recorddebugon.md): enables the record debug mode. When enabled, on the playback of the recorded commands the user is asked to press a key after each command. sleep and debugpause are automatically skipped.
[recorddebugoff](recorddebugoff.md): switches off record debug mode.
[debugpause](debugpause.md): wait for user to press any key.
[state](state.md): shows the auto ID mode, auto start client mode, records mode, and record debug mode states.

