

![Parralels](https://www.parallels.com/static/pl/fileadmin/res/img/navigation/pl-logo-dk.png)

# AppserverClient Command Line Interface

## uploadfile

upload a file to the remote session.

**Category: Sessions**


```
AppServerClientCLI uploadfile -id session:545567 [-localfile c:\test\send.txt] [-remotefile c:\test\receive.txt] [-autoclosewnd] [-waitforcomplete [20]]
```
* **` id (mandatory) `** Specify a session ID to use for the file transfer.
* **` localfile (optional) `** Specify the file to upload. If omitted, the user will be prompted to choose it.
* **` remotefile (optional) `** Specify the filepath where to store the uploaded file. If omitted, the user will be prompted to choose it.
* **` autoclosewnd (optional) `** When specified, the file transfer window will close when ready.
* **` waitforcomplete (optional) `** When specified with a time value in seconds, this command will return when the transfer is ready, has failed, or has timed out.
## Return codes:
  ok
  NotAvailable
  InvalidArgs
  InvalidId
  Exception
## Examples:
  AppServerClientCLI uploadfile -id session:545567
  AppServerClientCLI uploadfile -id session:545567 -localfile c:\test\send.txt
  AppServerClientCLI uploadfile -id session:545567 -localfile c:\test\send.txt -remotefile c:\test\receive.txt
  AppServerClientCLI uploadfile -id session:545567 -localfile c:\test\send.txt -remotefile c:\test\receive.txt -autoclosewnd
  AppServerClientCLI uploadfile -id session:545567 -localfile c:\test\send.txt -remotefile c:\test\receive.txt -autoclosewnd -waitforcomplete
  AppServerClientCLI uploadfile -id session:545567 -localfile c:\test\send.txt -remotefile c:\test\receive.txt -autoclosewnd -waitforcomplete 20
## Notes:
  Please note that the API returns when the file transfer is initiated and not when it is complete.
## See also:
[sendkeys](sendkeys.md)
[getsessionsinfo](getsessionsinfo.md)
[disconnectsession](disconnectsession.md)
[downloadfile](downloadfile.md)
