#!/bin/bash

# ....
# Main entry point.

TYPE="dpkg"
FILE=""
SSO_INSTALLED="0"

while [ $# -gt 0 ]; do
  if [ "x$1" = "x--sso_installed" ]; then
    SSO_INSTALLED="1"; shift 1
  elif [ "x$1" = "x--type" ]; then
    TYPE=$2; shift 2
  elif [ "x$1" = "x--file" ]; then
    FILE=$2; shift 2
  fi
done

if [ "root" != `whoami` ]; then
  if [ "x${TYPE}" = "xdpkg" ]; then
    SUDO=pkexec
  elif [ "x${TYPE}" = "xrpm" ]; then
    SUDO=pkexec
  elif [ "x${TYPE}" = "xtar" ]; then
    SUDO=gksudo
  fi
else
  SUDO=
fi

if [ -n ${FILE} ]; then
  if [ "x${TYPE}" = "xdpkg" ]; then
    ${SUDO} dpkg -i ${FILE}
  elif [ "x${TYPE}" = "xrpm" ]; then
    ${SUDO} rpm -U ${FILE}
  elif [ "x${TYPE}" = "xtar" ]; then
    ${SUDO} ./uninstall.sh
    cd /
    ${SUDO} tar jxvf ${FILE}
    if [ "x${SSO_INSTALLED}" = "x1" ]; then
      ${SUDO} ./install.sh --update --sso_installed
    else
      ${SUDO} ./install.sh --update
    fi
  fi
fi

../bin/2XClient &

