#!/bin/sh

USER_HOME=$(getent passwd `whoami` | cut -d: -f6)

#Check if opera is present and if url schema has been registered
if [ -x "`which opera 2>/dev/null`" ]; then
  if [ ! -e $USER_HOME/.opera ]; then
    mkdir $USER_HOME/.opera
  fi
  OPERA_PREFS_PATH=$USER_HOME/.opera/operaprefs.ini
  OPERA_HANDLERS_PATH=$USER_HOME/.opera/handlers.ini
  OPERA_FILE_HANDLER_PATH=$USER_HOME/.opera/filehandler.ini
  OPERA_TUXCLIENT_FLAG=""
  if [ -e $OPERA_HANDLERS_PATH ]; then
    OPERA_TUXCLIENT_FLAG=$(cat $OPERA_HANDLERS_PATH | sed -n '/tuxclient/=')
  else
( cat << EOF_OPERA_PREFS
Opera Preferences version 2.1
; Do not edit this file while Opera is running
; This file is stored in UTF-8 encoding

EOF_OPERA_PREFS
) >> $OPERA_HANDLERS_PATH
  fi

  if [ ! -e $OPERA_PREFS_PATH ] || [ -z $(cat $OPERA_PREFS_PATH | sed -n '/Trusted Protocols Section Info/=') ]; then
( cat << EOF_OPERA_PREFS
[Trusted Protocols Section Info]
Version=1
EOF_OPERA_PREFS
) >> $OPERA_PREFS_PATH
  fi
  
  if [ -z $OPERA_TUXCLIENT_FLAG ]; then
    #Tuxclient was not registered therefore register it here
( cat << EOF_OPERA
[tuxclient]
Type=Protocol
Handler=/opt/2X/Client/bin/appserverclient
Webhandler
Description
Flags=4
EOF_OPERA
) >> $OPERA_HANDLER_PATH

    if [ -x "`which gnome-session 2>/dev/null`" ]; then
( cat << EOF_FILE_HANDLER
Opera Preferences version 2.0
; Do not edit this file while Opera is running
; This file is stored in UTF-8 encoding
[Settings]
Default File Handler=gnome-open ,1
Default Directory Handler=gnome-open ,1
EOF_FILE_HANDLER
) > $OPERA_FILE_HANDLER_PATH
    elif [ -x "`which ksmserver 2>/dev/null`" ]; then
( cat << EOF_FILE_HANDLER
Opera Preferences version 2.0
; Do not edit this file while Opera is running
; This file is stored in UTF-8 encoding
[Settings]
Default File Handler=kfmclient exec,1
Default Directory Handler=kfmclient exec,1
EOF_FILE_HANDLER
) > $OPERA_FILE_HANDLER_PATH
    elif [ -x "`which xdg-open 2>/dev/null`" ]; then
( cat << EOF_FILE_HANDLER
Opera Preferences version 2.0
; Do not edit this file while Opera is running
; This file is stored in UTF-8 encoding
[Settings]
Default File Handler=xdg-open,1
Default Directory Handler=xdg-open,1
EOF_FILE_HANDLER
) > $OPERA_FILE_HANDLER_PATH
    fi #end if gnome/kde/xdg-open block
  fi #end if OPERA_TUXCLIENT_FLAG
fi #end if check if opera is present

#Check if google-chrome is present and if it has been registered
if [ -x "`which google-chrome 2>/dev/null`" ]; then
  GOOGLE_CONFIG_PATH=$USER_HOME/.config/google-chrome
  if [ ! -e $GOOGLE_CONFIG_PATH ]; then
    mkdir $GOOGLE_CONFIG_PATH
  fi

  if [ -e "$GOOGLE_CONFIG_PATH/Local State" ]; then
    GOOGLE_TUXCLIENT_FLAG=$(cat "$GOOGLE_CONFIG_PATH/Local State" | sed -n '/tuxclient/=')
    GOOGLE_PROTOCOL_PRESENT=$(cat "$GOOGLE_CONFIG_PATH/Local State" | sed -n '/protocol_handler/N;/excluded_schemes/=')
    if [ -z $GOOGLE_PROTOCOL_PRESENT ]; then
      sed -i '0,/{/ a\  "protocol_handler": {\n    "excluded_schemes": {\n      "tuxclient": false\n    },' "$GOOGLE_CONFIG_PATH/Local State"
    else
      if [ -z $GOOGLE_TUXCLIENT_FLAG ]; then
        #Tuxclient was not registered in google-chrome therefore register it here
        sed -i '/protocol_handler/N;/excluded_schemes/ a\"tuxclient": false,' "$GOOGLE_CONFIG_PATH/Local State" #adds '"tuxclient": false,' after match
        $GOOGLE_APPEND_PROT_BLOCK="FALSE"
      fi
    fi
  else
( cat << EOF_LOCAL_STATE_FILE
{
  "protocol_handler": {
    "excluded_schemes": {
      "tuxclient": false
    }
  }
}
EOF_LOCAL_STATE_FILE
) >> "$GOOGLE_CONFIG_PATH/Local State"    
  fi 
fi

#Check if chromium is present and if it has been registered
if [ -x "`which chromium 2>/dev/null`" ]; then
  CHROMIUM_CONFIG_PATH=$USER_HOME/.config/chromium
  if [ ! -e $CHROMIUM_CONFIG_PATH ]; then
    mkdir $CHROMIUM_CONFIG_PATH
  fi

  if [ -e "$CHROMIUM_CONFIG_PATH/Local State" ]; then
    CHROMIUM_TUXCLIENT_FLAG=$(cat "$CHROMIUM_CONFIG_PATH/Local State" | sed -n '/tuxclient/=')
    CHROMIUM_PROTOCOL_PRESENT=$(cat "$CHROMIUM_CONFIG_PATH/Local State" | sed -n '/protocol_handler/N;/excluded_schemes/=')
    if [ -z $CHROMIUM_PROTOCOL_PRESENT ]; then
      sed -i '0,/{/ a\  "protocol_handler": {\n    "excluded_schemes": {\n      "tuxclient": false\n    },' "$CHROMIUM_CONFIG_PATH/Local State"
    else
      if [ -z $CHROMIUM_TUXCLIENT_FLAG ]; then
        #Tuxclient was not registered in chromium therefore register it here
        sed -i '/protocol_handler/N;/excluded_schemes/ a\"tuxclient": false,' "$CHROMIUM_CONFIG_PATH/Local State" #adds '"tuxclient": false,' after match
      fi      
    fi
  else
( cat << EOF_LOCAL_STATE_FILE
{
  "protocol_handler": {
    "excluded_schemes": {
      "tuxclient": false
    }
  }
}
EOF_LOCAL_STATE_FILE
) >> "$CHROMIUM_CONFIG_PATH/Local State" 
  fi
fi

